//+------------------------------------------------------------------+
//|                                                      QQE new.mq4 |
//|                                                           mladen |
//+------------------------------------------------------------------+
#property copyright "mladen"
#property link      "mladenfx@gmail.com"

#property indicator_separate_window
#property indicator_buffers 5
#property indicator_color1  Green
#property indicator_color2  Maroon
#property indicator_color3  Red
#property indicator_color4  DimGray
#property indicator_color5  Lime
#property indicator_width1  2
#property indicator_width2  2
#property indicator_width3  2
#property indicator_width4  2
#property indicator_width5  2
#property indicator_levelcolor DimGray

//
//
//
//
//

extern int    SF         = 5;
extern int    RSIPeriod  = 14;
extern double WP         = 4.236;
extern double UpperBound = 60; 
extern double LowerBound = 40; 

//
//
//
//
//

double RsiMa[];
double Trend[];
double HistoU[];
double HistoM[];
double HistoD[];
double emas[][5];

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   SetIndexBuffer(0,HistoU); SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(1,HistoM); SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(2,HistoD); SetIndexStyle(2,DRAW_HISTOGRAM);
   SetIndexBuffer(3,RsiMa);  SetIndexLabel(0, "QQE");
   SetIndexBuffer(4,Trend);  SetIndexLabel(1, "QQE trend");
      SetLevelValue(0,UpperBound-50);
      SetLevelValue(1,LowerBound-50);
   return(0);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

#define iEma 0
#define iEmm 1
#define iQqe 2
#define iRsi 3
#define iTrn 4

//
//
//
//
//

int start()
{
   int counted_bars=IndicatorCounted();
   int i,r,limit;
   
   if(counted_bars < 0) return(-1);
   if(counted_bars > 0) counted_bars--;
           limit = Bars-counted_bars;
           if (ArrayRange(emas,0) != Bars) ArrayResize(emas,Bars); 

   //
   //
   //
   //
   //

   double alpha1 = 2.0/(SF+1.0);
   double alpha2 = 2.0/(RSIPeriod*2.0);
      
   for (i=limit, r=Bars-i-1; i>=0; i--,r++)
   {  
      emas[r][iRsi] = emas[r-1][iRsi] + alpha1*(iRSI(NULL,0,RSIPeriod,PRICE_CLOSE,i)   - emas[r-1][iRsi]);
      emas[r][iEma] = emas[r-1][iEma] + alpha2*(MathAbs(emas[r-1][iRsi]-emas[r][iRsi]) - emas[r-1][iEma]);
      emas[r][iEmm] = emas[r-1][iEmm] + alpha2*(emas[r][iEma] - emas[r-1][iEmm]);

      //
      //
      //
      //
      //

         double rsi0 = emas[r  ][iRsi];
         double rsi1 = emas[r-1][iRsi];
         double dar  = emas[r  ][iEmm]*WP;
         double tr   = emas[r-1][iQqe];
         double dv   = tr;
   
            if (rsi0 < tr) { tr = rsi0 + dar; if ((rsi1 < dv) && (tr > dv)) tr = dv; }
            if (rsi0 > tr) { tr = rsi0 - dar; if ((rsi1 > dv) && (tr < dv)) tr = dv; }
         
      //
      //
      //
      //
      //
         
      emas[r][iQqe] = tr;
      emas[r][iTrn] = emas[r-1][iTrn];
      RsiMa[i]      = emas[r][iRsi]-50;
      Trend[i]      = tr           -50;
      HistoU[i]     =  EMPTY_VALUE;
      HistoM[i]     =  EMPTY_VALUE;
      HistoD[i]     =  EMPTY_VALUE;
         if (RsiMa[i] > (UpperBound-50))                           HistoU[i] = RsiMa[i];
         if (RsiMa[i] < (LowerBound-50))                           HistoD[i] = RsiMa[i];
         if (HistoU[i] == EMPTY_VALUE && HistoD[i] == EMPTY_VALUE) HistoM[i] = RsiMa[i];
   }    

   //
   //
   //
   //
   //
       
   return(0);
}